
//scilab 5.5.2 , OS: Ubuntu 14.04
//Design of FIR filters using windowing 
// Design a digital FIR low pass filter with following specifications.
//a) Pass band cut-off frequency     :wp=__________radians
//b) Pass band ripple             :rp=__________dB
//c) Stop band cut-off frequency     :ws=__________radians
//d) Stop band attenuation               :rs=__________dB
//Choose an appropriate window function and determine impulse response and provide a plot of frequency response of the designed filter.

//Design example:
//Design a digital FIR low pass filter with following specifications.
//a) Pass band cut-off frequency     :0.3π rad
//b) Pass band ripple                       :0.25 dB
//c) Stop band cut-off frequency     :0.45π rad
//d) Stop band attenuation               : 50 dB
clc;
clear;
close;
wp=input('enter the pass band edge in rad');
ws=input('enter the stop band edge in rad');
rs=input('enter the stop band ripple in dB');
freq_points=1024;
freq_divs=(freq_points/2)-1;
k=4; //Hamming window (decided based on stop band attenuation)
trw=ws-wp;
N=(k*2*%pi/trw);
N=ceil(N);
remainder=N-fix(N./2).*2
if remainder==0
    N=N+1;
end

wc=wp;
aph=(N-1)/2;
for n=0:N-1
    if n==aph
        hdn_minusalph(n+1)=wc/%pi;
       
 else
     hdn_minusalph(n+1)= sin(wc.*(n-aph))./(%pi.*(n-aph));   
     
end
end
n=0:N-1;
wndw=window('hm',N);

hn=hdn_minusalph.*wndw';
figure(1);subplot(311);plot2d3(n,wndw);xlabel('n');ylabel('wndw');title('Hamming Window function');
subplot(312); plot2d3(n,hdn_minusalph);xlabel('n');ylabel('hdn_minusalph');title('Impulse response of IIR filter');
subplot(313); plot2d3(n,hn);xlabel('n');ylabel('hn');title('Impulse response of FIR filter');
//omega=0:%pi/freq_divs:%pi;  
h=[hn' zeros(1,freq_points-length(hn))];;//For a 1024 point DFT 
H=fft(h);
H_mag=20*log10(abs(H));
H_ang=atan(imag(H),real(H));
H_phase=unwrap(H_ang);
w=(0:freq_divs)./(freq_points);
w1=w*%pi;
figure(2);subplot(211),plot2d(w1,H_mag(1:512));
xtitle('Magnitude response','w (rad)','Magnitude(dB)');
subplot(212),plot2d(w1,H_phase(1:512));
xtitle('Phase Response','w (rad)','Phase (rad)');



//Problems:

//1. Design a digital FIR low pass filter with following specifications.
//a) Pass band cut-off frequency     :0.4π rad
//b) Pass band ripple                       :0.25 dB
//c) Stop band cut-off frequency     :0.6π rad
//d) Stop band attenuation               : 44 dB

//2. Design a digital FIR low pass filter with following specifications.
//a) Pass band cut-off frequency     :0.25π rad
//b) Pass band ripple                       :0.25 dB
//c) Stop band cut-off frequency     :0.3π rad
//d) Stop band attenuation               : 50 dB

